"use client";
import { MapContainer, TileLayer, Marker, Popup } from "react-leaflet";
import L from "leaflet";

const markerIcon = new L.Icon({
  iconUrl: "https://unpkg.com/leaflet@1.9.4/dist/images/marker-icon.png",
  iconRetinaUrl: "https://unpkg.com/leaflet@1.9.4/dist/images/marker-icon-2x.png",
  shadowUrl: "https://unpkg.com/leaflet@1.9.4/dist/images/marker-shadow.png",
  iconSize: [25, 41],
  iconAnchor: [12, 41],
});

export default function OSMMap({ center, hazards }: { center: { lat: number; lng: number }; hazards: any[] }) {
  return (
    <MapContainer center={center} zoom={15} style={{ width: "100%", height: "100%" }}>
      <TileLayer attribution="&copy; OpenStreetMap contributors" url="https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png" />
      {hazards.map((h) => (
        <Marker key={h.id} position={h.pin} icon={markerIcon}>
          <Popup>
            <b>{h.title}</b>
            <div style={{ fontSize: 12 }}>{h.severity} • {h.status}</div>
          </Popup>
        </Marker>
      ))}
    </MapContainer>
  );
}
