"use client";
import { useState } from "react";
import axios from "axios";

export default function Login() {
  const [email, setEmail] = useState("admin@demo.local");
  const [password, setPassword] = useState("admin12345");
  const [err, setErr] = useState<string | null>(null);

  const api = process.env.NEXT_PUBLIC_API_BASE || "http://localhost:8000";

  async function onLogin() {
    setErr(null);
    try {
      const r = await axios.post(`${api}/auth/login`, { email, password });
      localStorage.setItem("token", r.data.access_token);
      window.location.href = "/app/dashboard";
    } catch (e: any) {
      setErr(e?.response?.data?.detail || "Login failed");
    }
  }

  return (
    <main style={{ padding: 32, maxWidth: 520, margin: "0 auto" }}>
      <div style={{display:"flex",alignItems:"center",gap:12,marginBottom:14}}><img src="/assets/zora360-logo.png" style={{height:42,borderRadius:10}} alt="Zora360"/><div><div style={{fontWeight:900,letterSpacing:0.6}}>ZORA360</div><div style={{color:"#666"}}>Site Risk Intelligence</div></div></div><h1 style={{marginTop:0}}>Login</h1>
      <div style={{ display: "grid", gap: 10 }}>
        <input value={email} onChange={(e)=>setEmail(e.target.value)} placeholder="Email" />
        <input type="password" value={password} onChange={(e)=>setPassword(e.target.value)} placeholder="Password" />
        <button onClick={onLogin}>Sign in</button>
        {err && <p style={{ color: "crimson" }}>{err}</p>}
        <p style={{ color: "#666" }}>Demo: admin@demo.local / admin12345</p>
      </div>
    </main>
  );
}
