"use client";
import Link from "next/link";
import { motion } from "framer-motion";

export default function Home() {
  return (
    <main style={{ minHeight: "100vh", background: "radial-gradient(1200px 600px at 20% 10%, rgba(77,210,255,0.18), transparent 60%), #0B0F14", color: "#fff" }}>
      <header style={{ maxWidth: 1200, margin: "0 auto", padding: "28px 24px", display: "flex", alignItems: "center", justifyContent: "space-between" }}>
        <div style={{ display: "flex", gap: 12, alignItems: "center" }}>
          <img src="/assets/zora360-logo.png" alt="Zora360" style={{ height: 36, borderRadius: 10 }} />
          <div style={{ lineHeight: 1 }}>
            <div style={{ fontWeight: 800, letterSpacing: 0.6 }}>ZORA360</div>
            <div style={{ color: "#9fb3c8", fontSize: 12 }}>Site Risk Intelligence</div>
          </div>
        </div>
        <nav style={{ display: "flex", gap: 16, alignItems: "center" }}>
          <Link href="/app/login" style={{ background: "#4DD2FF", color: "#051018", padding: "10px 14px", borderRadius: 12, fontWeight: 700, textDecoration: "none" }}>Open Dashboard</Link>
        </nav>
      </header>

      <section style={{ maxWidth: 1200, margin: "0 auto", padding: "64px 24px 24px" }}>
        <motion.h1 initial={{ opacity: 0, y: 10 }} animate={{ opacity: 1, y: 0 }} transition={{ duration: 0.6 }}
          style={{ fontSize: 64, lineHeight: 1.02, margin: 0, letterSpacing: -1 }}>
          See risk.<br />Act early.
        </motion.h1>
        <p style={{ maxWidth: 760, color: "#cbd5e1", fontSize: 18, marginTop: 14 }}>
          Zora360 helps teams identify, map, and document health & safety risks using photos, video, and site context — with winter-ready signals for snow and ice.
        </p>
        <div style={{ display: "flex", gap: 12, marginTop: 26, flexWrap: "wrap" }}>
          <Link href="/app/login" style={{ background: "#4DD2FF", color: "#051018", padding: "14px 18px", borderRadius: 14, fontWeight: 800, textDecoration: "none" }}>
            Launch Dashboard
          </Link>
          <a href="http://localhost:8000/docs" target="_blank" style={{ border: "1px solid rgba(255,255,255,0.14)", color: "#fff", padding: "14px 18px", borderRadius: 14, fontWeight: 700, textDecoration: "none" }}>
            API Docs
          </a>
        </div>
      </section>

      <section style={{ maxWidth: 1200, margin: "0 auto", padding: "10px 24px 64px" }}>
        <div style={{ display: "grid", gridTemplateColumns: "repeat(12, 1fr)", gap: 14 }}>
          <div style={{ gridColumn: "span 5", background: "rgba(20,26,35,0.9)", border: "1px solid rgba(255,255,255,0.08)", borderRadius: 18, padding: 18 }}>
            <div style={{ color: "#4DD2FF", fontWeight: 800 }}>Capture</div>
            <div style={{ fontSize: 22, fontWeight: 800, marginTop: 6 }}>Photos, video, drone</div>
            <div style={{ color: "#9fb3c8", marginTop: 8 }}>Upload from field teams. GPS-aware. Evidence stays attached to hazards and exports.</div>
          </div>
          <div style={{ gridColumn: "span 4", background: "rgba(20,26,35,0.9)", border: "1px solid rgba(255,255,255,0.08)", borderRadius: 18, padding: 18 }}>
            <div style={{ color: "#4DD2FF", fontWeight: 800 }}>Map</div>
            <div style={{ fontSize: 22, fontWeight: 800, marginTop: 6 }}>Risk pins on OSM</div>
            <div style={{ color: "#9fb3c8", marginTop: 8 }}>OpenStreetMap + Leaflet means zero monthly map fees.</div>
          </div>
          <div style={{ gridColumn: "span 3", background: "rgba(20,26,35,0.9)", border: "1px solid rgba(255,255,255,0.08)", borderRadius: 18, padding: 18 }}>
            <div style={{ color: "#FFB703", fontWeight: 900 }}>Winter</div>
            <div style={{ fontSize: 22, fontWeight: 800, marginTop: 6 }}>Snow + ice signals</div>
            <div style={{ color: "#9fb3c8", marginTop: 8 }}>Built-in winter mode. Human verification keeps trust high.</div>
          </div>
        </div>
      </section>

      <footer style={{ borderTop: "1px solid rgba(255,255,255,0.08)", padding: "22px 24px", color: "#6b7c93" }}>
        <div style={{ maxWidth: 1200, margin: "0 auto", display: "flex", justifyContent: "space-between", gap: 12, flexWrap: "wrap" }}>
          <div>© {new Date().getFullYear()} Zora360</div>
          <div>zora360.com</div>
        </div>
      </footer>
    </main>
  );
}
