from __future__ import annotations
from sqlalchemy.orm import Session
from . import models
from .auth import hash_pw

def ensure_demo_data(db: Session):
    # org
    org = db.query(models.Org).first()
    if not org:
        org = models.Org(name="Demo Org", settings={})
        db.add(org); db.commit(); db.refresh(org)

    # admin
    admin = db.query(models.User).filter(models.User.email=="admin@demo.local").first()
    if not admin:
        admin = models.User(
            org_id=org.id,
            email="admin@demo.local",
            pw_hash=hash_pw("admin12345"),
            role="ADMIN",
            is_active=True
        )
        db.add(admin); db.commit()
