from __future__ import annotations
import os, boto3

S3_ENDPOINT = os.getenv("S3_ENDPOINT", "http://minio:9000")
S3_ACCESS_KEY = os.getenv("S3_ACCESS_KEY", "minioadmin")
S3_SECRET_KEY = os.getenv("S3_SECRET_KEY", "minioadmin123")
S3_BUCKET = os.getenv("S3_BUCKET", "hazardmap-media")
S3_REGION = os.getenv("S3_REGION", "us-east-1")

def client():
    return boto3.client(
        "s3",
        endpoint_url=S3_ENDPOINT,
        aws_access_key_id=S3_ACCESS_KEY,
        aws_secret_access_key=S3_SECRET_KEY,
        region_name=S3_REGION,
    )

def get_bytes(key: str) -> bytes:
    c = client()
    obj = c.get_object(Bucket=S3_BUCKET, Key=key)
    return obj["Body"].read()

def put_bytes(key: str, data: bytes, content_type: str):
    c = client()
    c.put_object(Bucket=S3_BUCKET, Key=key, Body=data, ContentType=content_type)
